/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.client.auth;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.glassfish.tyrus.client.auth.Authenticator;
import org.glassfish.tyrus.client.auth.BasicAuthenticator;
import org.glassfish.tyrus.client.auth.DigestAuthenticator;
import org.glassfish.tyrus.core.Beta;

@Beta
public class AuthConfig {
    static final Charset CHARACTER_SET = Charset.forName("iso-8859-1");
    static final String BASIC = "Basic";
    static final String DIGEST = "Digest";
    private final Map<String, Authenticator> authenticators;

    private AuthConfig(Map<String, Authenticator> authenticators) {
        TreeMap<String, Authenticator> map2 = new TreeMap<String, Authenticator>(String.CASE_INSENSITIVE_ORDER);
        map2.putAll(authenticators);
        this.authenticators = Collections.unmodifiableMap(map2);
    }

    public Map<String, Authenticator> getAuthenticators() {
        return this.authenticators;
    }

    public static Builder builder() {
        return Builder.create();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AuthConfig{");
        boolean first = true;
        for (Map.Entry<String, Authenticator> authenticator : this.authenticators.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(authenticator.getKey());
            sb.append("->");
            sb.append(authenticator.getValue().getClass().getName());
        }
        sb.append("}");
        return sb.toString();
    }

    public static final class Builder {
        private final Map<String, Authenticator> authenticators = new TreeMap<String, Authenticator>(String.CASE_INSENSITIVE_ORDER);

        private Builder() {
            this.authenticators.put(AuthConfig.BASIC, new BasicAuthenticator());
            this.authenticators.put(AuthConfig.DIGEST, new DigestAuthenticator());
        }

        public static Builder create() {
            return new Builder();
        }

        public final Builder registerAuthProvider(String scheme, Authenticator authenticator) {
            this.authenticators.put(scheme, authenticator);
            return this;
        }

        public final Builder disableProvidedBasicAuth() {
            if (this.authenticators.get(AuthConfig.BASIC) != null && this.authenticators.get(AuthConfig.BASIC) instanceof BasicAuthenticator) {
                this.authenticators.remove(AuthConfig.BASIC);
            }
            return this;
        }

        public final Builder disableProvidedDigestAuth() {
            if (this.authenticators.get(AuthConfig.DIGEST) != null && this.authenticators.get(AuthConfig.DIGEST) instanceof DigestAuthenticator) {
                this.authenticators.remove(AuthConfig.DIGEST);
            }
            return this;
        }

        public AuthConfig build() {
            return new AuthConfig(this.authenticators);
        }
    }
}

